<?php
/**
 * Register block styles.
 * Theme: Juliet's Diary
 */
function juliets_diary_register_block_styles() {
	$blocks = array( 'image', 'post-featured-image' );

	foreach( $blocks as $block ) {

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-grayscale',
				'label'        => __( 'Grayscale', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-grayscale{ filter: grayscale(100%); }',
			)
		);
	
		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-blur',
				'label'        => __( 'Blur', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-blur{ filter: blur(5px); }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-brightness',
				'label'        => __( 'Brightness', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-brightness{ filter: brightness(200%); }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-contrast',
				'label'        => __( 'Contrast', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-contrast{ filter: contrast(200%); }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-hue-90',
				'label'        => __( 'Hue-90', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-hue-90{ filter: hue-rotate(90deg); }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-hue-180',
				'label'        => __( 'Hue-180', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-hue-180{ filter: hue-rotate(180deg); }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-hue-270',
				'label'        => __( 'Hue-270', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-hue-270{ filter: hue-rotate(270deg); }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-invert',
				'label'        => __( 'Invert', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-invert{ filter: invert(100%); }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-opacity',
				'label'        => __( 'Opacity', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-opacity{ filter: opacity(30%); }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-saturate',
				'label'        => __( 'Saturate', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-saturate{ filter: saturate(8); }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-sepia',
				'label'        => __( 'Sepia', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-sepia{ filter: sepia(100%); }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-fromgray',
				'label'        => __( 'Gray →', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-fromgray { filter: grayscale(100%); } .is-style-juliets-diary-fromgray:hover { filter: grayscale(0%); }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-togray',
				'label'        => __( '→ Gray', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-togray:hover { filter: grayscale(100%); }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-fromblur',
				'label'        => __( 'Blur →', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-fromblur { filter: blur(5px); } .is-style-juliets-diary-fromblur:hover { filter: none; }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-toblur',
				'label'        => __( '→ Blur', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-toblur:hover { filter: blur(5px); }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-frombrightness',
				'label'        => __( 'Brightness →', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-frombrightness { filter: brightness(200%); } .is-style-juliets-diary-frombrightness:hover { filter: none; }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-tobrightness',
				'label'        => __( '→ Brightness', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-tobrightness:hover { filter: brightness(200%); }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-fromcontrast',
				'label'        => __( 'Contrast →', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-fromcontrast { filter: contrast(200%); } .is-style-juliets-diary-fromcontrast:hover { filter: none; }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-tocontrast',
				'label'        => __( '→ Contrast', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-tocontrast:hover { filter: contrast(200%); }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-fromhue90',
				'label'        => __( 'Hue90 →', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-fromhue90 { filter: hue-rotate(90deg); } .is-style-juliets-diary-fromhue90:hover { filter: none; }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-tohue90',
				'label'        => __( '→ Hue90', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-tohue90:hover { filter: hue-rotate(90deg); }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-fromhue180',
				'label'        => __( 'Hue180 →', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-fromhue180 { filter: hue-rotate(180deg); } .is-style-juliets-diary-fromhue180:hover { filter: none; }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-tohue180',
				'label'        => __( '→ Hue180', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-tohue180:hover { filter: hue-rotate(180deg); }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-fromhue270',
				'label'        => __( 'Hue270 →', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-fromhue270 { filter: hue-rotate(270deg); } .is-style-juliets-diary-fromhue270:hover { filter: none; }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-tohue270',
				'label'        => __( '→ Hue270', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-tohue270:hover { filter: hue-rotate(270deg); }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-frominvert',
				'label'        => __( 'Invert →', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-frominvert { filter: invert(100%); } .is-style-juliets-diary-frominvert:hover { filter: none; }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-toinvert',
				'label'        => __( '→ Invert', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-toinvert:hover { filter: invert(100%); }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-fromopacity',
				'label'        => __( 'Opacity →', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-fromopacity { filter: opacity(30%); } .is-style-juliets-diary-fromopacity:hover { filter: none; }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-toopacity',
				'label'        => __( '→ Opacity', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-toopacity:hover { filter: opacity(30%); }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-fromsaturate',
				'label'        => __( 'Saturate →', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-fromsaturate { filter: saturate(8); } .is-style-juliets-diary-fromsaturate:hover { filter: none; }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-tosaturate',
				'label'        => __( '→ Saturate', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-tosaturate:hover { filter: saturate(8); }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-fromsepia',
				'label'        => __( 'Sepia →', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-fromsepia { filter: sepia(100%); } .is-style-juliets-diary-fromsepia:hover { filter: none; }',
			)
		);

		register_block_style(
			'core/' . $block,
			array(
				'name'         => 'juliets-diary-tosepia',
				'label'        => __( '→ Sepia', 'juliets-diary' ),
				'inline_style' => '.is-style-juliets-diary-tosepia:hover { filter: sepia(100%); }',
			)
		);

	}
}

add_action( 'init', 'juliets_diary_register_block_styles' );

function juliets_diary_wp_custom_welcome_page() {
	
	 include(get_template_directory() .'/assets/benvenuto/benvenuto.php');

}

function juliets_diary_wp_custom_welcome_menu() {
    add_menu_page(
        __( 'Welcome', 'juliets-diary' ),
        __( 'Welcome', 'juliets-diary' ),
        'edit_posts', /* min Author role */
        'custom-welcome',
        'juliets_diary_wp_custom_welcome_page',
        'dashicons-welcome-learn-more',
        3
    );
}
add_action( 'admin_menu', 'juliets_diary_wp_custom_welcome_menu' );
